#ifndef _DES_H_
#define _DES_H_

#define DES_BLOCK_LENGTH              8
#define DES_KEY_LENGTH                8

//#define DES_TEST_CASES                (sizeof(des_test)/sizeof(des_test[0]))

/*after encrypt/decrypt we must have original input: symmetric crypto algorithm*/
/*DES in CBC mode*/
void
des_main(void);

/*
 * encryptDES: DES encryption function
 *
 * Parameters:
 *   [in] key: key of 8 bytes
 *   [in] input_data: pointer to in data
 *   [out] output_data: pointer to out data
 *   [in] data_length: number of bytes of input data. Must be divisible by 8 (DES block)
 *   [in] init_vector: init_vector to use during xor
 * Return:
 *   0 if OK, otherwise error
 *
 */
unsigned char
encryptDES(unsigned char *key, unsigned char *input_data, unsigned char *output_data, unsigned short data_length, unsigned char *init_vector);

/*
 * decryptDES: DES decryption function
 *
 * Parameters:
 *   [in] key: key of 8 bytes
 *   [in] input_data: pointer to in data
 *   [out] output_data: pointer to out data
 *   [in] data_length: number of bytes of input data. Must be divisible by 8 (DES block)
 *   [in] init_vector: init_vector to use during xor
 * Return:
 *   0 if OK, otherwise error
 *
 */
unsigned char
decryptDES(unsigned char *key, unsigned char *input_data, unsigned char *output_data, unsigned short data_length, unsigned char *init_vector);

#endif